/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.abilities.Ability;
import mage.abilities.effects.ReplacementEffectImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.events.ZoneChangeEvent;

class SithMagicReplacementEffect
extends ReplacementEffectImpl {
    SithMagicReplacementEffect() {
        super(Duration.EndOfTurn, Outcome.Exile);
        this.staticText = "or if it would leave the battlefield";
    }

    private SithMagicReplacementEffect(SithMagicReplacementEffect effect) {
        super((ReplacementEffectImpl)effect);
    }

    public SithMagicReplacementEffect copy() {
        return new SithMagicReplacementEffect(this);
    }

    public boolean replaceEvent(GameEvent event, Ability source, Game game) {
        ((ZoneChangeEvent)event).setToZone(Zone.EXILED);
        return false;
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.ZONE_CHANGE;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        return event.getTargetId().equals(source.getFirstTarget()) && ((ZoneChangeEvent)event).getFromZone() == Zone.BATTLEFIELD && ((ZoneChangeEvent)event).getToZone() != Zone.EXILED;
    }
}

