/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import java.util.UUID;
import mage.MageInt;
import mage.abilities.Ability;
import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.continuous.BoostSourceEffect;
import mage.abilities.effects.common.continuous.GainAbilitySourceEffect;
import mage.abilities.keyword.HasteAbility;
import mage.abilities.keyword.TrampleAbility;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.constants.CardType;
import mage.constants.Duration;
import mage.constants.SubType;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;

public final class SithRavager
extends CardImpl {
    public SithRavager(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId, setInfo, new CardType[]{CardType.CREATURE}, "{2}{R}");
        this.subtype.add((Object)SubType.HUMAN);
        this.subtype.add((Object)SubType.SITH);
        this.power = new MageInt(3);
        this.toughness = new MageInt(1);
        this.addAbility((Ability)new LostNonCombatLifeTriggeredAbility());
    }

    private SithRavager(SithRavager card) {
        super((CardImpl)card);
    }

    public SithRavager copy() {
        return new SithRavager(this);
    }

    public static class LostNonCombatLifeTriggeredAbility
    extends TriggeredAbilityImpl {
        public LostNonCombatLifeTriggeredAbility() {
            super(Zone.BATTLEFIELD, (Effect)new BoostSourceEffect(1, 0, Duration.EndOfTurn), false);
            this.addEffect((Effect)new GainAbilitySourceEffect((Ability)HasteAbility.getInstance(), Duration.EndOfTurn));
            this.addEffect((Effect)new GainAbilitySourceEffect((Ability)TrampleAbility.getInstance(), Duration.EndOfTurn));
        }

        private LostNonCombatLifeTriggeredAbility(LostNonCombatLifeTriggeredAbility ability) {
            super((TriggeredAbilityImpl)ability);
        }

        public LostNonCombatLifeTriggeredAbility copy() {
            return new LostNonCombatLifeTriggeredAbility(this);
        }

        public boolean checkEventType(GameEvent event, Game game) {
            return event.getType() == GameEvent.EventType.LOST_LIFE;
        }

        public boolean checkTrigger(GameEvent event, Game game) {
            return !event.getFlag() && game.getOpponents(game.getControllerId(this.getSourceId())).contains(event.getPlayerId());
        }

        public String getRule() {
            return "<i>Hate</i> &mdash; Whenever an opponent loses life from a source other than combat damage, {this} gains haste and trample until end of turn.";
        }
    }
}

