/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.costs.common.PayLifeCost;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Cards;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;

class SivrissNightmareSpeakerEffect
extends OneShotEffect {
    SivrissNightmareSpeakerEffect() {
        super(Outcome.Benefit);
        this.staticText = "for each opponent, you mill a card, then return that card from your graveyard to your hand unless that player pays 3 life";
    }

    private SivrissNightmareSpeakerEffect(SivrissNightmareSpeakerEffect effect) {
        super((OneShotEffect)effect);
    }

    public SivrissNightmareSpeakerEffect copy() {
        return new SivrissNightmareSpeakerEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        for (UUID playerId : game.getOpponents(source.getControllerId())) {
            Player opponent = game.getPlayer(playerId);
            if (opponent == null) continue;
            Cards cards = player.millCards(1, source, game);
            PayLifeCost cost = new PayLifeCost(3);
            if (cost.canPay(source, source, playerId, game) && opponent.chooseUse(this.outcome, "Pay 3 life?", source, game) && cost.pay(source, game, source, playerId, true)) continue;
            cards.retainZone(Zone.GRAVEYARD, game);
            player.moveCards(cards, Zone.HAND, source, game);
        }
        return true;
    }
}

