/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.continuous.BoostTargetEffect;
import mage.cards.Card;
import mage.cards.s.SixSidedDieToughnessEffect;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class SixSidedDieEffect
extends OneShotEffect {
    SixSidedDieEffect() {
        super(Outcome.Detriment);
        this.setText("choose target creature. Roll a six-sided die.<br>1 \u2014 It has base toughness 1 until end of turn.<br>2 \u2014 Put two -1/-1 counters on it.<br>3 \u2014 {this} deals 3 damage to it and you gain 3 life.<br>4 \u2014 It gets -4/-4 until end of turn.<br>5 \u2014 Destroy it.<br>6 \u2014 Exile it.");
    }

    private SixSidedDieEffect(SixSidedDieEffect effect) {
        super((OneShotEffect)effect);
    }

    public SixSidedDieEffect copy() {
        return new SixSidedDieEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        Permanent permanent = game.getPermanent(this.getTargetPointer().getFirst(game, source));
        if (player == null || permanent == null) {
            return false;
        }
        int result = player.rollDice(this.outcome, source, game, 6);
        switch (result) {
            case 1: {
                game.addEffect((ContinuousEffect)new SixSidedDieToughnessEffect(), source);
                break;
            }
            case 2: {
                permanent.addCounters(CounterType.M1M1.createInstance(2), source, game);
                break;
            }
            case 3: {
                permanent.damage(3, source, game);
                player.gainLife(3, game, source);
                break;
            }
            case 4: {
                game.addEffect((ContinuousEffect)new BoostTargetEffect(-4, -4, Duration.EndOfTurn), source);
                break;
            }
            case 5: {
                permanent.destroy(source, game);
                break;
            }
            case 6: {
                player.moveCards((Card)permanent, Zone.EXILED, source, game);
            }
        }
        return true;
    }
}

