/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import java.util.Set;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetOpponent;

class SixyBeastEffect
extends OneShotEffect {
    SixyBeastEffect() {
        super(Outcome.BoostCreature);
        this.staticText = "you secretly put six or fewer +1/+1 counters on it, then an opponent guesses the number of counters. If that player guesses right, sacrifice {this} after it enters the battlefield";
    }

    private SixyBeastEffect(SixyBeastEffect effect) {
        super((OneShotEffect)effect);
    }

    public SixyBeastEffect copy() {
        return new SixyBeastEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent permanent = game.getPermanentEntering(source.getSourceId());
        Player controller = game.getPlayer(source.getControllerId());
        if (permanent != null && controller != null) {
            int counterAmount = controller.getAmount(0, 6, "Secretly put up to six counters on " + permanent.getName(), source, game);
            permanent.addCounters(CounterType.P1P1.createInstance(counterAmount), source.getControllerId(), source, game);
            Player opponent = null;
            Set opponents = game.getOpponents(source.getControllerId());
            if (!opponents.isEmpty()) {
                if (opponents.size() > 1) {
                    TargetOpponent targetOpponent = new TargetOpponent(true);
                    if (controller.chooseTarget(Outcome.Neutral, (Target)targetOpponent, source, game)) {
                        opponent = game.getPlayer(targetOpponent.getFirstTarget());
                    }
                } else {
                    opponent = game.getPlayer((UUID)opponents.iterator().next());
                }
            }
            if (opponent != null) {
                int guessedAmount = opponent.getAmount(0, 6, "Guess the number of counters on " + permanent.getName(), source, game);
                game.informPlayers(opponent.getLogName() + " guessed " + guessedAmount + " as the number of counters on " + permanent.getLogName());
                if (counterAmount == guessedAmount) {
                    permanent.sacrifice(source, game);
                }
            }
            return true;
        }
        return false;
    }
}

