/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.abilities.DelayedTriggeredAbility;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.CreateTokenEffect;
import mage.constants.Duration;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.events.ZoneChangeEvent;
import mage.game.permanent.token.SkeletonRegenerateToken;
import mage.game.permanent.token.Token;
import mage.watchers.common.DamagedByWatcher;

class SkeletonizeDelayedTriggeredAbility
extends DelayedTriggeredAbility {
    public SkeletonizeDelayedTriggeredAbility() {
        super((Effect)new CreateTokenEffect((Token)new SkeletonRegenerateToken()), Duration.EndOfTurn);
        this.setTriggerPhrase("When a creature dealt damage this way dies this turn, ");
    }

    private SkeletonizeDelayedTriggeredAbility(SkeletonizeDelayedTriggeredAbility ability) {
        super((DelayedTriggeredAbility)ability);
    }

    public SkeletonizeDelayedTriggeredAbility copy() {
        return new SkeletonizeDelayedTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.ZONE_CHANGE;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        DamagedByWatcher watcher;
        ZoneChangeEvent zce = (ZoneChangeEvent)event;
        if (zce.isDiesEvent() && (watcher = (DamagedByWatcher)game.getState().getWatcher(DamagedByWatcher.class, this.getSourceId())) != null) {
            return watcher.wasDamaged(zce.getTarget(), game);
        }
        return false;
    }
}

