/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;

class SkinInvasionEffect
extends OneShotEffect {
    SkinInvasionEffect() {
        super(Outcome.PutCardInPlay);
        this.staticText = "return this card to the battlefield transformed under your control";
    }

    private SkinInvasionEffect(SkinInvasionEffect effect) {
        super((OneShotEffect)effect);
    }

    public SkinInvasionEffect copy() {
        return new SkinInvasionEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Card card = game.getCard(source.getSourceId());
        Player controller = game.getPlayer(source.getControllerId());
        if (card != null && controller != null) {
            game.getState().setValue("EnterTransformed" + source.getSourceId(), (Object)Boolean.TRUE);
            controller.moveCards(card, Zone.BATTLEFIELD, source, game);
            return true;
        }
        return false;
    }
}

