/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class SkittishValeskEffect
extends OneShotEffect {
    SkittishValeskEffect() {
        super(Outcome.Neutral);
        this.staticText = "flip a coin. If you lose the flip, turn {this} face down";
    }

    private SkittishValeskEffect(SkittishValeskEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        Permanent permanent = game.getPermanent(source.getSourceId());
        if (controller != null && permanent != null && !controller.flipCoin(source, game, true)) {
            return permanent.turnFaceDown(source, game, source.getControllerId());
        }
        return false;
    }

    public SkittishValeskEffect copy() {
        return new SkittishValeskEffect(this);
    }
}

