/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import java.util.Collection;
import java.util.HashMap;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.counters.CounterType;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetDiscard;

class SkullslitherWormEffect
extends OneShotEffect {
    SkullslitherWormEffect() {
        super(Outcome.Benefit);
        this.staticText = "each opponent discards a card. For each opponent who can't, put two +1/+1 counters on {this}";
    }

    private SkullslitherWormEffect(SkullslitherWormEffect effect) {
        super((OneShotEffect)effect);
    }

    public SkullslitherWormEffect copy() {
        return new SkullslitherWormEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player;
        Permanent permanent = game.getPermanent(source.getSourceId());
        HashMap<UUID, CardsImpl> cardsToDiscard = new HashMap<UUID, CardsImpl>();
        for (UUID playerId : game.getOpponents(source.getControllerId(), true)) {
            player = game.getPlayer(playerId);
            if (player == null) continue;
            int numberOfCardsToDiscard = Math.min(1, player.getHand().size());
            CardsImpl cards = new CardsImpl();
            TargetDiscard target = new TargetDiscard(numberOfCardsToDiscard, numberOfCardsToDiscard, StaticFilters.FILTER_CARD, playerId);
            player.chooseTarget(this.outcome, (Target)target, source, game);
            cards.addAll((Collection)target.getTargets());
            cardsToDiscard.put(playerId, cards);
        }
        for (UUID playerId : game.getOpponents(source.getControllerId(), true)) {
            int amountDiscarded;
            player = game.getPlayer(playerId);
            if (player == null || (amountDiscarded = player.discard((Cards)cardsToDiscard.get(playerId), false, source, game).size()) != 0 || permanent == null) continue;
            permanent.addCounters(CounterType.P1P1.createInstance(2), source, game);
        }
        return true;
    }
}

