/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;

class SkyclaveInvaderEffect
extends OneShotEffect {
    SkyclaveInvaderEffect() {
        super(Outcome.Benefit);
        this.staticText = "look at the top card of your library. If it's a land card, you may put it onto the battlefield. If you don't put the card onto the battlefield, put it into your hand";
    }

    private SkyclaveInvaderEffect(SkyclaveInvaderEffect effect) {
        super((OneShotEffect)effect);
    }

    public SkyclaveInvaderEffect copy() {
        return new SkyclaveInvaderEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        Card card = player.getLibrary().getFromTop(game);
        if (card == null) {
            return false;
        }
        player.lookAtCards(source, null, (Cards)new CardsImpl(card), game);
        return player.moveCards(card, card.isLand(game) && player.chooseUse(Outcome.PutCardInPlay, "Put " + card.getName() + " onto the battlefield or into your hand?", null, "Battlefield", "Hand", source, game) ? Zone.BATTLEFIELD : Zone.HAND, source, game);
    }
}

