/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.continuous.BoostTargetEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class SkyclavePickAxeEffect
extends OneShotEffect {
    SkyclavePickAxeEffect() {
        super(Outcome.Benefit);
        this.staticText = "equipped creature gets +2/+2 until end of turn";
    }

    private SkyclavePickAxeEffect(SkyclavePickAxeEffect effect) {
        super((OneShotEffect)effect);
    }

    public SkyclavePickAxeEffect copy() {
        return new SkyclavePickAxeEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent permanent = game.getPermanentOrLKIBattlefield(source.getSourceId());
        if (permanent == null || game.getPermanent(permanent.getAttachedTo()) == null) {
            return false;
        }
        game.addEffect(new BoostTargetEffect(2, 2).setTargetPointer((TargetPointer)new FixedTarget(permanent.getAttachedTo(), game)), source);
        return true;
    }
}

