/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.continuous.GainControlTargetEffect;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.target.Target;
import mage.target.TargetPermanent;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class SkyfireKirinEffect
extends OneShotEffect {
    SkyfireKirinEffect() {
        super(Outcome.Detriment);
        this.staticText = "you may gain control of target creature with that spell's mana value until end of turn";
    }

    private SkyfireKirinEffect(SkyfireKirinEffect effect) {
        super((OneShotEffect)effect);
    }

    public SkyfireKirinEffect copy() {
        return new SkyfireKirinEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent targetCreature = null;
        for (Target target : source.getTargets()) {
            if (!(target instanceof TargetPermanent)) continue;
            targetCreature = game.getPermanent(target.getFirstTarget());
        }
        if (targetCreature != null) {
            GainControlTargetEffect effect = new GainControlTargetEffect(Duration.EndOfTurn);
            effect.setTargetPointer((TargetPointer)new FixedTarget(targetCreature.getId(), game));
            game.addEffect((ContinuousEffect)effect, source);
            return true;
        }
        return false;
    }
}

