/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import java.util.UUID;
import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.SearchEffect;
import mage.cards.Card;
import mage.constants.CardType;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.Predicates;
import mage.game.Game;
import mage.players.Player;
import mage.target.common.TargetCardInLibrary;
import mage.util.CardUtil;

class SkyshipWeatherlightEffect
extends SearchEffect {
    private static final FilterCard filter = new FilterCard("artifact and/or creature card");

    public SkyshipWeatherlightEffect() {
        super(new TargetCardInLibrary(0, Integer.MAX_VALUE, filter), Outcome.Neutral);
        this.staticText = "search your library for any number of artifact and/or creature cards and exile them. Then shuffle";
    }

    private SkyshipWeatherlightEffect(SkyshipWeatherlightEffect effect) {
        super((SearchEffect)effect);
    }

    public SkyshipWeatherlightEffect copy() {
        return new SkyshipWeatherlightEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        MageObject sourceObject = source.getSourceObject(game);
        if (sourceObject != null && controller != null) {
            if (controller.searchLibrary(this.target, source, game)) {
                UUID exileZone = CardUtil.getExileZoneId((Game)game, (UUID)source.getSourceId(), (int)source.getStackMomentSourceZCC());
                if (!this.target.getTargets().isEmpty()) {
                    for (UUID cardID : this.target.getTargets()) {
                        Card card = controller.getLibrary().getCard(cardID, game);
                        if (card == null) continue;
                        controller.moveCardToExileWithInfo(card, exileZone, sourceObject.getIdName(), source, game, Zone.LIBRARY, true);
                    }
                }
            }
            controller.shuffleLibrary(source, game);
            return true;
        }
        return false;
    }

    static {
        filter.add(Predicates.or((Predicate)CardType.ARTIFACT.getPredicate(), (Predicate)CardType.CREATURE.getPredicate()));
    }
}

