/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import java.util.Set;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.CardType;
import mage.constants.Outcome;
import mage.filter.FilterCard;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.Predicates;
import mage.game.ExileZone;
import mage.game.Game;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetCardInExile;
import mage.util.CardUtil;

class SkywayRobberCastForFreeEffect
extends OneShotEffect {
    private static final FilterCard filter = new FilterCard("an artifact, instant, or sorcery card");

    public SkywayRobberCastForFreeEffect() {
        super(Outcome.PlayForFree);
        this.staticText = "you may cast an artifact, instant, or sorcery spell from among cards exiled with {this} without paying its mana cost";
    }

    private SkywayRobberCastForFreeEffect(SkywayRobberCastForFreeEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        String exileZoneName = CardUtil.getObjectZoneString((String)"SourceExileZone", (UUID)source.getSourceId(), (Game)game, (int)(source.getStackMomentSourceZCC() - 1), (boolean)false);
        UUID exileId = CardUtil.getExileZoneId((String)exileZoneName, (Game)game);
        ExileZone exileZone = game.getExile().getExileZone(exileId);
        if (exileZone == null) {
            return false;
        }
        Set possibleCards = exileZone.getCards(filter, game);
        if (possibleCards.isEmpty()) {
            return false;
        }
        boolean choseToPlay = controller.chooseUse(Outcome.PlayForFree, "Cast an artifact, instant, or sorcery spell from among cards exiled with Skyway Robber without paying its mana cost?", source, game);
        if (!choseToPlay) {
            return false;
        }
        TargetCardInExile target = new TargetCardInExile(filter, exileId);
        if (!controller.chooseTarget(Outcome.PlayForFree, (Target)target, source, game)) {
            return false;
        }
        Card chosenCard = game.getCard(target.getFirstTarget());
        if (chosenCard == null) {
            return false;
        }
        return CardUtil.castSpellWithAttributesForFree((Player)controller, (Ability)source, (Game)game, (Card)chosenCard);
    }

    public SkywayRobberCastForFreeEffect copy() {
        return new SkywayRobberCastForFreeEffect(this);
    }

    static {
        filter.add(Predicates.or((Predicate[])new Predicate[]{CardType.ARTIFACT.getPredicate(), CardType.INSTANT.getPredicate(), CardType.SORCERY.getPredicate()}));
    }
}

