/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.MageObject;
import mage.abilities.TriggeredAbility;
import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.CreateTokenEffect;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.events.ZoneChangeEvent;
import mage.game.permanent.PermanentToken;
import mage.game.permanent.token.PowerstoneToken;
import mage.game.permanent.token.Token;

class SlagstoneRefineryTriggeredAbility
extends TriggeredAbilityImpl {
    SlagstoneRefineryTriggeredAbility() {
        super(Zone.BATTLEFIELD, (Effect)new CreateTokenEffect((Token)new PowerstoneToken(), 1, true));
        this.setLeavesTheBattlefieldTrigger(true);
    }

    private SlagstoneRefineryTriggeredAbility(SlagstoneRefineryTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public SlagstoneRefineryTriggeredAbility copy() {
        return new SlagstoneRefineryTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.ZONE_CHANGE;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        ZoneChangeEvent zEvent = (ZoneChangeEvent)event;
        if (zEvent.getFromZone() == Zone.BATTLEFIELD && (zEvent.getToZone() == Zone.GRAVEYARD || zEvent.getToZone() == Zone.EXILED)) {
            if (zEvent.getTargetId().equals(this.getSourceId())) {
                return true;
            }
            return zEvent.getTarget().isArtifact(game) && !(zEvent.getTarget() instanceof PermanentToken) && zEvent.getTarget().getControllerId().equals(this.getControllerId());
        }
        return false;
    }

    public String getRule() {
        return "Whenever {this} or another nontoken artifact you control is put into a graveyard from the battlefield or is put into exile from the battlefield, create a tapped Powerstone token.";
    }

    public boolean isInUseableZone(Game game, MageObject sourceObject, GameEvent event) {
        return TriggeredAbilityImpl.isInUseableZoneDiesTrigger((TriggeredAbility)this, (MageObject)sourceObject, (GameEvent)event, (Game)game);
    }
}

