/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.abilities.Ability;
import mage.abilities.costs.Cost;
import mage.abilities.costs.mana.GenericManaCost;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.abilities.keyword.EncoreAbility;
import mage.cards.Card;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.constants.SubType;
import mage.filter.FilterCard;
import mage.filter.common.FilterCreatureCard;
import mage.filter.predicate.Predicate;
import mage.game.Game;
import mage.players.Player;

class SliverGravemotherEffect
extends ContinuousEffectImpl {
    private static final FilterCard filter = new FilterCreatureCard();

    public SliverGravemotherEffect() {
        super(Duration.WhileOnBattlefield, Layer.AbilityAddingRemovingEffects_6, SubLayer.NA, Outcome.AddAbility);
        this.staticText = "each Sliver creature card in your graveyard has encore {X}, where X is its mana value";
    }

    private SliverGravemotherEffect(SliverGravemotherEffect effect) {
        super((ContinuousEffectImpl)effect);
    }

    public SliverGravemotherEffect copy() {
        return new SliverGravemotherEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        for (Card card : player.getGraveyard().getCards(filter, game)) {
            game.getState().addOtherAbility(card, (Ability)new EncoreAbility((Cost)new GenericManaCost(card.getManaValue())));
        }
        return true;
    }

    static {
        filter.add((Predicate)SubType.SLIVER.getPredicate());
    }
}

