/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class SmashToSmithereensEffect
extends OneShotEffect {
    SmashToSmithereensEffect() {
        super(Outcome.Detriment);
        this.staticText = "Destroy target artifact. {this} deals 3 damage to that artifact's controller";
    }

    private SmashToSmithereensEffect(SmashToSmithereensEffect effect) {
        super((OneShotEffect)effect);
    }

    public SmashToSmithereensEffect copy() {
        return new SmashToSmithereensEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent targetArtifact = this.getTargetPointer().getFirstTargetPermanentOrLKI(game, source);
        if (targetArtifact != null) {
            Player controllerOfArtifact = game.getPlayer(targetArtifact.getControllerId());
            targetArtifact.destroy(source, game, false);
            if (controllerOfArtifact != null) {
                controllerOfArtifact.damage(3, source.getSourceId(), source, game);
            }
            return true;
        }
        return false;
    }
}

