/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import java.util.List;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.dynamicvalue.DynamicValue;
import mage.abilities.effects.Effect;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.watchers.common.PermanentsEnteredBattlefieldWatcher;

enum SmugglersShareTreasureValue implements DynamicValue
{
    instance;


    public int calculate(Game game, Ability source, Effect effect) {
        Player controller = game.getPlayer(source.getControllerId());
        PermanentsEnteredBattlefieldWatcher watcher = (PermanentsEnteredBattlefieldWatcher)game.getState().getWatcher(PermanentsEnteredBattlefieldWatcher.class);
        if (watcher == null || controller == null) {
            return 0;
        }
        int treasureCount = 0;
        for (UUID opponentId : game.getOpponents(controller.getId())) {
            List enteredPermanents;
            Player opponent = game.getPlayer(opponentId);
            if (opponent == null || (enteredPermanents = watcher.getThisTurnEnteringPermanents(opponentId)) == null) continue;
            int enteredLandCount = 0;
            for (Permanent permanent : enteredPermanents) {
                if (!permanent.isLand(game)) continue;
                ++enteredLandCount;
            }
            if (enteredLandCount < 2) continue;
            ++treasureCount;
        }
        return treasureCount;
    }

    public SmugglersShareTreasureValue copy() {
        return instance;
    }

    public String getMessage() {
        return "opponent who had two or more lands enter the battlefield under their control this turn";
    }

    public String toString() {
        return "1";
    }
}

