/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import java.util.Collection;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.common.FilterCreatureCard;
import mage.game.Game;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetCardInHand;

class SmugglersSurpriseEffect
extends OneShotEffect {
    SmugglersSurpriseEffect() {
        super(Outcome.PutCreatureInPlay);
        this.staticText = "You may put up to two creature cards from your hand onto the battlefield";
    }

    private SmugglersSurpriseEffect(SmugglersSurpriseEffect effect) {
        super((OneShotEffect)effect);
    }

    public SmugglersSurpriseEffect copy() {
        return new SmugglersSurpriseEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        TargetCardInHand target = new TargetCardInHand(0, 2, (FilterCard)new FilterCreatureCard("creature cards"));
        if (controller.choose(Outcome.PutCreatureInPlay, (Target)target, source, game)) {
            return controller.moveCards(new CardsImpl((Collection)target.getTargets()).getCards(game), Zone.BATTLEFIELD, source, game);
        }
        return false;
    }
}

