/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.abilities.keyword.SunburstAbility;
import mage.cards.Card;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.game.stack.Spell;

class SolarArrayEffect
extends ContinuousEffectImpl {
    private UUID permanentId;
    private int zoneChangeCounter;

    SolarArrayEffect() {
        super(Duration.OneUse, Layer.AbilityAddingRemovingEffects_6, SubLayer.NA, Outcome.AddAbility);
        this.staticText = "that spell gains sunburst";
    }

    private SolarArrayEffect(SolarArrayEffect effect) {
        super((ContinuousEffectImpl)effect);
        this.permanentId = effect.permanentId;
        this.zoneChangeCounter = effect.zoneChangeCounter;
    }

    public SolarArrayEffect copy() {
        return new SolarArrayEffect(this);
    }

    public void init(Ability source, Game game) {
        super.init(source, game);
        Spell object = game.getSpell(this.getTargetPointer().getFirst(game, source));
        if (object != null) {
            this.permanentId = object.getSourceId();
            this.zoneChangeCounter = game.getState().getZoneChangeCounter(object.getSourceId()) + 1;
        }
    }

    public boolean apply(Game game, Ability source) {
        if (game.getState().getZoneChangeCounter(this.permanentId) >= this.zoneChangeCounter) {
            this.discard();
            return false;
        }
        Permanent permanent = game.getPermanent(this.permanentId);
        if (permanent != null && permanent.getZoneChangeCounter(game) <= this.zoneChangeCounter) {
            permanent.addAbility((Ability)new SunburstAbility((Card)permanent), source.getSourceId(), game);
            return true;
        }
        Spell spell = game.getStack().getSpell(this.getTargetPointer().getFirst(game, source));
        if (spell != null) {
            game.getState().addOtherAbility(spell.getCard(), (Ability)new SunburstAbility((Card)spell), true);
        }
        return true;
    }
}

