/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.costs.Cost;
import mage.abilities.costs.mana.ManaCostsImpl;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.abilities.keyword.UnearthAbility;
import mage.cards.Card;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.constants.SubType;
import mage.game.Game;
import mage.players.Player;

class SolemnDoomguideEffect
extends ContinuousEffectImpl {
    SolemnDoomguideEffect() {
        super(Duration.WhileOnBattlefield, Layer.AbilityAddingRemovingEffects_6, SubLayer.NA, Outcome.AddAbility);
        this.staticText = "each creature card in your graveyard that's a Cleric, Rogue, Warrior, and/or Wizard has unearth {1}{B}";
    }

    private SolemnDoomguideEffect(SolemnDoomguideEffect effect) {
        super((ContinuousEffectImpl)effect);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        for (UUID cardId : controller.getGraveyard()) {
            Card card = game.getCard(cardId);
            if (card == null || !card.isCreature(game) || !card.hasSubtype(SubType.CLERIC, game) && !card.hasSubtype(SubType.ROGUE, game) && !card.hasSubtype(SubType.WARRIOR, game) && !card.hasSubtype(SubType.WIZARD, game)) continue;
            UnearthAbility ability = new UnearthAbility((Cost)new ManaCostsImpl("{1}{B}"));
            ability.setSourceId(cardId);
            ability.setControllerId(card.getOwnerId());
            game.getState().addOtherAbility(card, (Ability)ability);
        }
        return true;
    }

    public SolemnDoomguideEffect copy() {
        return new SolemnDoomguideEffect(this);
    }
}

