/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.abilities.Ability;
import mage.abilities.effects.ReplacementEffectImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.players.Player;

class SolemnityEffect
extends ReplacementEffectImpl {
    SolemnityEffect() {
        super(Duration.WhileOnBattlefield, Outcome.Benefit);
        this.staticText = "Players can't get counters";
    }

    private SolemnityEffect(SolemnityEffect effect) {
        super((ReplacementEffectImpl)effect);
    }

    public SolemnityEffect copy() {
        return new SolemnityEffect(this);
    }

    public boolean replaceEvent(GameEvent event, Ability source, Game game) {
        return true;
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.ADD_COUNTERS;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        Player player = game.getPlayer(event.getTargetId());
        return player != null;
    }
}

