/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import java.util.Objects;
import mage.abilities.Ability;
import mage.abilities.DelayedTriggeredAbility;
import mage.abilities.effects.OneShotEffect;
import mage.cards.s.SongOfBloodTriggeredAbility;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;

class SongOfBloodEffect
extends OneShotEffect {
    SongOfBloodEffect() {
        super(Outcome.LoseLife);
        this.staticText = "Mill four cards. Whenever a creature attacks this turn, it gets +1/+0 until end of turn for each creature card put into your graveyard this way.";
    }

    private SongOfBloodEffect(SongOfBloodEffect effect) {
        super((OneShotEffect)effect);
    }

    public SongOfBloodEffect copy() {
        return new SongOfBloodEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        int creatures = controller.millCards(4, source, game).getCards(game).stream().filter(Objects::nonNull).filter(card -> game.getState().getZone(card.getId()) == Zone.GRAVEYARD).filter(card1 -> card1.isCreature(game)).mapToInt(x -> 1).sum();
        SongOfBloodTriggeredAbility delayedAbility = new SongOfBloodTriggeredAbility(creatures);
        game.addDelayedTriggeredAbility((DelayedTriggeredAbility)delayedAbility, source);
        return true;
    }
}

