/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.abilities.keyword.HarmonizeAbility;
import mage.cards.Card;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.game.Game;

class SongcrafterMageEffect
extends ContinuousEffectImpl {
    SongcrafterMageEffect() {
        super(Duration.EndOfTurn, Layer.AbilityAddingRemovingEffects_6, SubLayer.NA, Outcome.AddAbility);
        this.staticText = "target instant or sorcery card in your graveyard gains harmonize until end of turn. Its harmonize cost is equal to its mana cost";
    }

    private SongcrafterMageEffect(SongcrafterMageEffect effect) {
        super((ContinuousEffectImpl)effect);
    }

    public SongcrafterMageEffect copy() {
        return new SongcrafterMageEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Card card = game.getCard(this.getTargetPointer().getFirst(game, source));
        if (card == null) {
            return false;
        }
        HarmonizeAbility ability = new HarmonizeAbility(card, card.getManaCost().getText());
        ability.setSourceId(card.getId());
        ability.setControllerId(card.getOwnerId());
        game.getState().addOtherAbility(card, (Ability)ability);
        return true;
    }
}

