/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import java.util.Optional;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class SonicShriekerEffect
extends OneShotEffect {
    SonicShriekerEffect() {
        super(Outcome.Benefit);
        this.staticText = "it deals 2 damage to any target and you gain 2 life. If a player is dealt damage this way, they discard a card";
    }

    private SonicShriekerEffect(SonicShriekerEffect effect) {
        super((OneShotEffect)effect);
    }

    public SonicShriekerEffect copy() {
        return new SonicShriekerEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = SonicShriekerEffect.dealDamage(this.getTargetPointer().getFirst(game, source), game, source);
        Optional.ofNullable(source.getControllerId()).map(arg_0 -> ((Game)game).getPlayer(arg_0)).ifPresent(controller -> controller.gainLife(2, game, source));
        if (player != null) {
            player.discard(1, false, false, source, game);
        }
        return true;
    }

    private static Player dealDamage(UUID targetId, Game game, Ability source) {
        Permanent permanent = game.getPermanent(targetId);
        if (permanent != null) {
            permanent.damage(2, source, game);
            return null;
        }
        Player player = game.getPlayer(targetId);
        if (player != null && player.damage(2, source, game) > 0) {
            return player;
        }
        return null;
    }
}

