/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.constants.SubType;
import mage.game.Game;
import mage.game.permanent.Permanent;

class SorinVengefulBloodlordEffect
extends ContinuousEffectImpl {
    SorinVengefulBloodlordEffect() {
        super(Duration.Custom, Outcome.Neutral);
        this.staticText = "That creature is a Vampire in addition to its other types";
    }

    private SorinVengefulBloodlordEffect(SorinVengefulBloodlordEffect effect) {
        super((ContinuousEffectImpl)effect);
    }

    public boolean hasLayer(Layer layer) {
        return layer == Layer.TypeChangingEffects_4;
    }

    public boolean apply(Layer layer, SubLayer sublayer, Ability source, Game game) {
        Permanent creature;
        if (source.getTargets().getFirstTarget() == null) {
            creature = game.getPermanent(this.getTargetPointer().getFirst(game, source));
        } else {
            creature = game.getPermanent(source.getTargets().getFirstTarget());
            if (creature == null) {
                creature = game.getPermanentEntering(source.getTargets().getFirstTarget());
            }
        }
        if (creature != null) {
            creature.addSubType(game, new SubType[]{SubType.VAMPIRE});
            return true;
        }
        this.used = true;
        return false;
    }

    public boolean apply(Game game, Ability source) {
        return false;
    }

    public SorinVengefulBloodlordEffect copy() {
        return new SorinVengefulBloodlordEffect(this);
    }
}

