/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.constants.SubType;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.DamagedEvent;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class SosukeSonOfSeshiroTriggeredAbility
extends TriggeredAbilityImpl {
    SosukeSonOfSeshiroTriggeredAbility(Effect effect) {
        super(Zone.BATTLEFIELD, effect);
    }

    private SosukeSonOfSeshiroTriggeredAbility(SosukeSonOfSeshiroTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public SosukeSonOfSeshiroTriggeredAbility copy() {
        return new SosukeSonOfSeshiroTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.DAMAGED_PERMANENT;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        if (!((DamagedEvent)event).isCombatDamage()) {
            return false;
        }
        Permanent sourceCreature = game.getPermanent(event.getSourceId());
        Permanent targetCreature = game.getPermanent(event.getTargetId());
        if (!(sourceCreature != null && sourceCreature.isControlledBy(this.getControllerId()) && targetCreature != null && targetCreature.isCreature(game) && sourceCreature.hasSubtype(SubType.WARRIOR, game))) {
            return false;
        }
        this.getEffects().setTargetPointer((TargetPointer)new FixedTarget(targetCreature, game));
        return true;
    }

    public String getRule() {
        return "Whenever a Warrior you control deals combat damage to a creature, destroy that creature at end of combat.";
    }
}

