/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.abilities.Ability;
import mage.abilities.costs.Cost;
import mage.abilities.costs.common.ExileTargetCost;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.ReturnFromGraveyardToBattlefieldTargetEffect;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.permanent.Permanent;

class SoulExchangeEffect
extends OneShotEffect {
    SoulExchangeEffect() {
        super(Outcome.Benefit);
        this.setText("Return target creature card from your graveyard to the battlefield. Put a +2/+2 counter on that creature if the exiled creature was a Thrull.");
    }

    private SoulExchangeEffect(SoulExchangeEffect effect) {
        super((OneShotEffect)effect);
    }

    public SoulExchangeEffect copy() {
        return new SoulExchangeEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        ReturnFromGraveyardToBattlefieldTargetEffect effect = new ReturnFromGraveyardToBattlefieldTargetEffect();
        if (!effect.apply(game, source)) {
            return false;
        }
        for (Cost c : source.getCosts()) {
            if (!c.isPaid() || !(c instanceof ExileTargetCost)) continue;
            for (Permanent exiled : ((ExileTargetCost)c).getPermanents()) {
                if (exiled != null) {
                    if (!exiled.hasSubtype(SubType.THRULL, game)) continue;
                    game.getPermanent(source.getFirstTarget()).addCounters(CounterType.P2P2.createInstance(), source.getControllerId(), source, game);
                    return true;
                }
                return false;
            }
        }
        return true;
    }
}

