/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.CardType;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.predicate.Predicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.TargetCard;
import mage.util.CardUtil;

class SoulFoundryImprintEffect
extends OneShotEffect {
    private static final FilterCard filter = new FilterCard("creature card from your hand");

    SoulFoundryImprintEffect() {
        super(Outcome.Neutral);
        this.staticText = "you may exile a creature card from your hand";
    }

    private SoulFoundryImprintEffect(SoulFoundryImprintEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        Permanent sourcePermanent = game.getPermanentOrLKIBattlefield(source.getSourceId());
        if (controller != null) {
            Card card;
            TargetCard target;
            if (!controller.getHand().isEmpty() && (target = new TargetCard(Zone.HAND, filter)).canChoose(source.getControllerId(), source, game) && controller.choose(Outcome.Benefit, controller.getHand(), target, source, game) && (card = controller.getHand().get(target.getFirstTarget(), game)) != null) {
                controller.moveCardToExileWithInfo(card, source.getSourceId(), sourcePermanent.getIdName() + " (Imprint)", source, game, Zone.HAND, true);
                Permanent permanent = game.getPermanent(source.getSourceId());
                if (permanent != null) {
                    permanent.imprint(card.getId(), game);
                    permanent.addInfo("imprint", CardUtil.addToolTipMarkTags((String)("[Imprinted card - " + card.getLogName() + ']')), game);
                }
            }
            return true;
        }
        return false;
    }

    public SoulFoundryImprintEffect copy() {
        return new SoulFoundryImprintEffect(this);
    }

    static {
        filter.add((Predicate)CardType.CREATURE.getPredicate());
    }
}

