/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import java.util.LinkedList;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.game.Game;
import mage.game.permanent.Permanent;

class SoulNovaEffect
extends OneShotEffect {
    SoulNovaEffect() {
        super(Outcome.DestroyPermanent);
        this.staticText = "Exile target attacking creature and all Equipment attached to it.";
    }

    private SoulNovaEffect(SoulNovaEffect effect) {
        super((OneShotEffect)effect);
    }

    public SoulNovaEffect copy() {
        return new SoulNovaEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent permanent = game.getPermanent(source.getFirstTarget());
        if (permanent != null) {
            LinkedList attachments = new LinkedList();
            attachments.addAll(permanent.getAttachments());
            for (UUID attachmentId : attachments) {
                Permanent attachment = game.getPermanent(attachmentId);
                if (!attachment.hasSubtype(SubType.EQUIPMENT, game)) continue;
                attachment.moveToExile(null, "", source, game);
            }
            permanent.moveToExile(null, "", source, game);
            return true;
        }
        return false;
    }
}

