/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetCardInGraveyard;

class SoulOfWindgraceEffect
extends OneShotEffect {
    SoulOfWindgraceEffect() {
        super(Outcome.PutLandInPlay);
        this.staticText = "you may put a land card from a graveyard onto the battlefield tapped under your control";
    }

    private SoulOfWindgraceEffect(SoulOfWindgraceEffect effect) {
        super((OneShotEffect)effect);
    }

    public SoulOfWindgraceEffect copy() {
        return new SoulOfWindgraceEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        TargetCardInGraveyard target = new TargetCardInGraveyard(0, 1, (FilterCard)StaticFilters.FILTER_CARD_LAND_A, true);
        player.choose(this.outcome, (Target)target, source, game);
        Card card = game.getCard(target.getFirstTarget());
        return card != null && player.moveCards(card, Zone.BATTLEFIELD, source, game, true, false, false, null);
    }
}

