/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.s.SoulPartitionCastEffect;
import mage.cards.s.SoulPartitionCostEffect;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class SoulPartitionEffect
extends OneShotEffect {
    SoulPartitionEffect() {
        super(Outcome.Exile);
        this.staticText = "Exile target nonland permanent. For as long as that card remains exiled, its owner may play it. A spell cast by an opponent this way costs {2} more to cast.";
    }

    private SoulPartitionEffect(SoulPartitionEffect effect) {
        super((OneShotEffect)effect);
    }

    public SoulPartitionEffect copy() {
        return new SoulPartitionEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        UUID targetId = source.getFirstTarget();
        Player controller = game.getPlayer(source.getControllerId());
        Permanent permanent = game.getPermanent(targetId);
        if (controller == null || permanent == null) {
            return false;
        }
        controller.moveCards((Card)permanent, Zone.EXILED, source, game);
        Card card = game.getCard(targetId);
        if (card != null && game.getState().getZone(targetId) == Zone.EXILED) {
            game.addEffect((ContinuousEffect)new SoulPartitionCastEffect(card, game), source);
            if (controller.hasOpponent(card.getOwnerId(), game)) {
                game.addEffect((ContinuousEffect)new SoulPartitionCostEffect(card, game), source);
            }
        }
        return true;
    }
}

