/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.MageObject;
import mage.MageObjectReference;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.constants.CardType;
import mage.constants.DependencyType;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.game.Game;
import mage.game.permanent.Permanent;

class SoulSculptorEffect
extends ContinuousEffectImpl {
    SoulSculptorEffect() {
        super(Duration.Custom, Outcome.LoseAbility);
        this.staticText = "target becomes an Enchantment and loses all abilites";
        this.dependencyTypes.add(DependencyType.EnchantmentAddingRemoving);
        this.dependencyTypes.add(DependencyType.AddingAbility);
    }

    private SoulSculptorEffect(SoulSculptorEffect effect) {
        super((ContinuousEffectImpl)effect);
    }

    public SoulSculptorEffect copy() {
        return new SoulSculptorEffect(this);
    }

    public void init(Ability source, Game game) {
        super.init(source, game);
        Permanent targetPermanent = game.getPermanent(source.getFirstTarget());
        if (targetPermanent != null) {
            this.affectedObjectList.add(new MageObjectReference((MageObject)targetPermanent, game));
        }
    }

    public boolean apply(Layer layer, SubLayer sublayer, Ability source, Game game) {
        Permanent permanent = ((MageObjectReference)this.affectedObjectList.get(0)).getPermanent(game);
        if (permanent == null) {
            this.discard();
            return false;
        }
        switch (layer) {
            case TypeChangingEffects_4: {
                permanent.removeAllCardTypes(game);
                permanent.retainAllEnchantmentSubTypes(game);
                permanent.addCardType(game, new CardType[]{CardType.ENCHANTMENT});
                break;
            }
            case AbilityAddingRemovingEffects_6: {
                if (sublayer != SubLayer.NA) break;
                permanent.getAbilities().clear();
            }
        }
        return true;
    }

    public boolean apply(Game game, Ability source) {
        return false;
    }

    public boolean hasLayer(Layer layer) {
        return Layer.TypeChangingEffects_4 == layer || Layer.AbilityAddingRemovingEffects_6 == layer;
    }
}

