/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.permanent.token.ZombieToken2;
import mage.players.Player;

class SoulSeparatorEffect
extends OneShotEffect {
    SoulSeparatorEffect() {
        super(Outcome.PutCreatureInPlay);
        this.staticText = "Create a black Zombie creature token with power equal to that card's power and toughness equal to that card's toughness";
    }

    private SoulSeparatorEffect(SoulSeparatorEffect effect) {
        super((OneShotEffect)effect);
    }

    public SoulSeparatorEffect copy() {
        return new SoulSeparatorEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Card creatureCard = game.getCard(this.getTargetPointer().getFirst(game, source));
        Player controller = game.getPlayer(source.getControllerId());
        if (creatureCard != null && controller != null) {
            boolean result = false;
            if (game.getState().getZone(creatureCard.getId()) == Zone.GRAVEYARD) {
                result = controller.moveCardToExileWithInfo(creatureCard, null, "", source, game, Zone.GRAVEYARD, true);
                ZombieToken2 token = new ZombieToken2(creatureCard.getPower().getValue(), creatureCard.getToughness().getValue());
                token.putOntoBattlefield(1, game, source, source.getControllerId());
            }
            return result;
        }
        return false;
    }
}

