/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;
import mage.target.Target;

class SoulShackledZombieEffect
extends OneShotEffect {
    SoulShackledZombieEffect() {
        super(Outcome.Benefit);
        this.staticText = "exile up to two target cards from a single graveyard. If at least one creature card was exiled this way, each opponent loses 2 life and you gain 2 life.";
    }

    private SoulShackledZombieEffect(SoulShackledZombieEffect effect) {
        super((OneShotEffect)effect);
    }

    public SoulShackledZombieEffect copy() {
        return new SoulShackledZombieEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        CardsImpl cards = new CardsImpl();
        for (Target target : source.getTargets()) {
            for (UUID targetId : target.getTargets()) {
                Card card = game.getCard(targetId);
                if (card == null) continue;
                cards.add(card);
            }
        }
        player.moveCards((Cards)cards, Zone.EXILED, source, game);
        for (Card card : cards.getCards(game)) {
            if (card == null || !card.isCreature(game)) continue;
            player.gainLife(2, game, source);
            for (UUID opponentId : game.getOpponents(source.getControllerId())) {
                Player opponent = game.getPlayer(opponentId);
                if (opponent == null) continue;
                opponent.loseLife(2, game, source, false);
            }
        }
        return true;
    }
}

