/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.abilities.Ability;
import mage.abilities.costs.Cost;
import mage.abilities.costs.common.SacrificeAllCost;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class SoulblastEffect
extends OneShotEffect {
    SoulblastEffect() {
        super(Outcome.Benefit);
        this.staticText = "{this} deals damage to any target equal to the total power of the sacrificed creatures";
    }

    private SoulblastEffect(SoulblastEffect effect) {
        super((OneShotEffect)effect);
    }

    public SoulblastEffect copy() {
        return new SoulblastEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        int power = 0;
        for (Cost cost : source.getCosts()) {
            if (!(cost instanceof SacrificeAllCost)) continue;
            for (Permanent permanent : ((SacrificeAllCost)cost).getPermanents()) {
                power += permanent.getPower().getValue();
            }
        }
        if (power > 0) {
            Player player = game.getPlayer(this.getTargetPointer().getFirst(game, source));
            if (player != null) {
                player.damage(power, source.getSourceId(), source, game);
            } else {
                Permanent creature = game.getPermanent(this.getTargetPointer().getFirst(game, source));
                if (creature != null) {
                    creature.damage(power, source.getSourceId(), source, game, false, true);
                }
            }
        }
        return true;
    }
}

