/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousRuleModifyingEffectImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;

class SoullessJailerCastEffect
extends ContinuousRuleModifyingEffectImpl {
    SoullessJailerCastEffect() {
        super(Duration.WhileOnBattlefield, Outcome.Benefit);
        this.staticText = "players can't cast noncreature spells from graveyards or exile";
    }

    private SoullessJailerCastEffect(SoullessJailerCastEffect effect) {
        super((ContinuousRuleModifyingEffectImpl)effect);
    }

    public SoullessJailerCastEffect copy() {
        return new SoullessJailerCastEffect(this);
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.CAST_SPELL;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        return game.getCard(event.getSourceId()) != null && !game.getCard(event.getSourceId()).isCreature(game) && (game.getState().getZone(event.getSourceId()) == Zone.GRAVEYARD || game.getState().getZone(event.getSourceId()) == Zone.EXILED);
    }
}

