/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.ComparisonType;
import mage.constants.Outcome;
import mage.filter.FilterCard;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.mageobject.ManaValuePredicate;
import mage.game.Game;
import mage.players.Player;

class SoulstealerAxeEffect
extends OneShotEffect {
    SoulstealerAxeEffect() {
        super(Outcome.Benefit);
        this.staticText = "seek a card with mana value equal to that damage";
    }

    private SoulstealerAxeEffect(SoulstealerAxeEffect effect) {
        super((OneShotEffect)effect);
    }

    public SoulstealerAxeEffect copy() {
        return new SoulstealerAxeEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        int damage = (Integer)this.getValue("damage");
        FilterCard filter = new FilterCard();
        filter.add((Predicate)new ManaValuePredicate(ComparisonType.EQUAL_TO, damage));
        return player.seekCard(filter, source, game);
    }
}

