/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.card.AuraCardCanAttachToPermanentId;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.common.TargetCardInLibrary;

class SovereignsOfLostAlaraEffect
extends OneShotEffect {
    SovereignsOfLostAlaraEffect() {
        super(Outcome.BoostCreature);
        this.staticText = "search your library for an Aura card that could enchant that creature, put it onto the battlefield attached to that creature, then shuffle";
    }

    private SovereignsOfLostAlaraEffect(SovereignsOfLostAlaraEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        Permanent attackingCreature = game.getPermanent(this.getTargetPointer().getFirst(game, source));
        if (controller != null && attackingCreature != null) {
            FilterCard filter = new FilterCard("Aura card that could enchant " + attackingCreature.getName());
            filter.add((Predicate)SubType.AURA.getPredicate());
            filter.add((Predicate)new AuraCardCanAttachToPermanentId(attackingCreature.getId()));
            TargetCardInLibrary target = new TargetCardInLibrary(filter);
            target.withNotTarget(true);
            if (controller.searchLibrary(target, source, game) && target.getFirstTarget() != null) {
                Card aura = game.getCard(target.getFirstTarget());
                game.getState().setValue("attachTo:" + aura.getId(), (Object)attackingCreature);
                controller.moveCards(aura, Zone.BATTLEFIELD, source, game);
                attackingCreature.addAttachment(aura.getId(), source, game);
            }
            controller.shuffleLibrary(source, game);
            return true;
        }
        return false;
    }

    public SovereignsOfLostAlaraEffect copy() {
        return new SovereignsOfLostAlaraEffect(this);
    }
}

