/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.util.CardUtil;

class SparkFiendEffect
extends OneShotEffect {
    SparkFiendEffect() {
        super(Outcome.Sacrifice);
        this.staticText = "roll two six-sided dice. If you rolled 2, 3, or 12, sacrifice {this}. If you rolled 7 or 11, don't roll dice for {this} during any of your following upkeeps. If you rolled any other total, note that total";
    }

    private SparkFiendEffect(SparkFiendEffect effect) {
        super((OneShotEffect)effect);
    }

    public SparkFiendEffect copy() {
        return new SparkFiendEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            int roll = controller.rollDice(this.outcome, source, game, 6, 2, 0).stream().mapToInt(x -> x).sum();
            MageObject mageObject = game.getObject(source);
            if (mageObject instanceof Permanent) {
                Permanent sourcePermanent = (Permanent)mageObject;
                if (roll == 2 || roll == 3 || roll == 12) {
                    sourcePermanent.sacrifice(source, game);
                } else if (roll == 7 || roll == 11) {
                    game.getState().setValue("SparkFiend" + source.getSourceId().toString(), (Object)0);
                    sourcePermanent.addInfo("roll counter", CardUtil.addToolTipMarkTags((String)""), game);
                } else {
                    game.getState().setValue("SparkFiend" + source.getSourceId().toString(), (Object)roll);
                    sourcePermanent.addInfo("roll counter", CardUtil.addToolTipMarkTags((String)("Noted roll: " + roll)), game);
                }
            }
            return true;
        }
        return false;
    }
}

