/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.MageObject;
import mage.MageObjectReference;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.s.SparkOfCreativityPlayEffect;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class SparkOfCreativityEffect
extends OneShotEffect {
    SparkOfCreativityEffect() {
        super(Outcome.Benefit);
        this.staticText = "Choose target creature. Exile the top card of your library. You may have {this} deal damage to that creature equal to the exiled card's mana value. If you don't, you may play that card until end of turn";
    }

    private SparkOfCreativityEffect(SparkOfCreativityEffect effect) {
        super((OneShotEffect)effect);
    }

    public SparkOfCreativityEffect copy() {
        return new SparkOfCreativityEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        MageObject sourceObject = source.getSourceObject(game);
        if (controller != null && sourceObject != null) {
            Card card = controller.getLibrary().getFromTop(game);
            if (card != null) {
                controller.moveCards(card, Zone.EXILED, source, game);
                Permanent targetCreature = game.getPermanent(this.getTargetPointer().getFirst(game, source));
                if (targetCreature != null) {
                    int cmc = card.getManaCost().manaValue();
                    if (controller.chooseUse(this.outcome, "Let " + sourceObject.getLogName() + " deal " + cmc + " damage to " + targetCreature.getLogName() + '?', source, game)) {
                        targetCreature.damage(cmc, source.getSourceId(), source, game, false, true);
                        return true;
                    }
                }
                game.addEffect((ContinuousEffect)new SparkOfCreativityPlayEffect(new MageObjectReference((MageObject)card, game)), source);
            }
            return true;
        }
        return false;
    }
}

