/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.Mode;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.DestroyTargetEffect;
import mage.abilities.effects.common.continuous.GainAbilityTargetEffect;
import mage.abilities.effects.common.counter.AddCountersTargetEffect;
import mage.abilities.keyword.HexproofAbility;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.constants.CardType;
import mage.constants.ComparisonType;
import mage.counters.CounterType;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterCreaturePermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.mageobject.PowerPredicate;
import mage.target.Target;
import mage.target.TargetPermanent;
import mage.target.common.TargetControlledCreaturePermanent;

public final class SpectacularTactics
extends CardImpl {
    private static final FilterPermanent filter = new FilterCreaturePermanent("creature with power 4 or greater");

    public SpectacularTactics(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId, setInfo, new CardType[]{CardType.INSTANT}, "{1}{W}");
        this.getSpellAbility().addEffect((Effect)new AddCountersTargetEffect(CounterType.P1P1.createInstance()));
        this.getSpellAbility().addEffect((Effect)new GainAbilityTargetEffect((Ability)HexproofAbility.getInstance()).setText("It gains hexproof until end of turn"));
        this.getSpellAbility().addTarget((Target)new TargetControlledCreaturePermanent());
        this.getSpellAbility().addMode(new Mode((Effect)new DestroyTargetEffect()).addTarget((Target)new TargetPermanent(filter)));
    }

    private SpectacularTactics(SpectacularTactics card) {
        super((CardImpl)card);
    }

    public SpectacularTactics copy() {
        return new SpectacularTactics(this);
    }

    static {
        filter.add((Predicate)new PowerPredicate(ComparisonType.MORE_THAN, 3));
    }
}

