/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.StaticFilters;
import mage.filter.common.FilterNonlandCard;
import mage.game.Game;
import mage.players.Player;
import mage.target.TargetCard;
import mage.target.common.TargetCardInHand;

class SpectersShriekEffect
extends OneShotEffect {
    private static final FilterCard filter = new FilterCard("card in your hand (to exile)");

    SpectersShriekEffect() {
        super(Outcome.Benefit);
        this.staticText = "Target opponent reveals their hand. You may choose a nonland card from it. If you do, that player exiles that card. If a nonblack card is exiled this way, exile a card from your hand.";
    }

    private SpectersShriekEffect(SpectersShriekEffect effect) {
        super((OneShotEffect)effect);
    }

    public SpectersShriekEffect copy() {
        return new SpectersShriekEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        Player player = game.getPlayer(source.getFirstTarget());
        if (controller == null || player == null) {
            return false;
        }
        player.revealCards(source, player.getHand(), game);
        if (player.getHand().count((FilterCard)StaticFilters.FILTER_CARD_NON_LAND, game) == 0 || !controller.chooseUse(Outcome.Benefit, "Exile a card from " + player.getName() + "'s hand?", source, game)) {
            return false;
        }
        TargetCard target = new TargetCard(0, 1, Zone.HAND, (FilterCard)new FilterNonlandCard());
        if (!controller.choose(Outcome.Benefit, player.getHand(), target, source, game)) {
            return false;
        }
        Card card = game.getCard(target.getFirstTarget());
        if (card == null) {
            return false;
        }
        boolean isBlack = card.getColor(game).isBlack();
        player.moveCards(card, Zone.EXILED, source, game);
        if (isBlack || controller.getHand().isEmpty()) {
            return true;
        }
        target = new TargetCardInHand(filter);
        target.withNotTarget(true);
        return controller.choose(Outcome.Detriment, controller.getHand(), target, source, game) && controller.moveCards(game.getCard(target.getFirstTarget()), Zone.EXILED, source, game);
    }
}

