/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import java.util.ArrayList;
import java.util.List;
import mage.Mana;
import mage.abilities.Ability;
import mage.abilities.effects.mana.ManaEffect;
import mage.choices.ManaChoice;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;
import mage.target.TargetPlayer;

class SpectralSearchlightManaEffect
extends ManaEffect {
    SpectralSearchlightManaEffect() {
        this.staticText = "Choose a player. That player adds one mana of any color they choose";
    }

    private SpectralSearchlightManaEffect(SpectralSearchlightManaEffect effect) {
        super((ManaEffect)effect);
    }

    public Player getPlayer(Game game, Ability source) {
        TargetPlayer target;
        if (!game.inCheckPlayableState() && (target = new TargetPlayer(1, 1, true)).choose(Outcome.PutManaInPool, source.getControllerId(), source, game)) {
            return game.getPlayer(target.getFirstTarget());
        }
        return game.getPlayer(source.getControllerId());
    }

    public List<Mana> getNetMana(Game game, Ability source) {
        ArrayList<Mana> netMana = new ArrayList<Mana>();
        netMana.add(Mana.AnyMana((int)1));
        return netMana;
    }

    public Mana produceMana(Game game, Ability source) {
        if (game != null) {
            Player player = this.getPlayer(game, source);
            return ManaChoice.chooseAnyColor((Player)player, (Game)game, (int)1);
        }
        return new Mana();
    }

    public SpectralSearchlightManaEffect copy() {
        return new SpectralSearchlightManaEffect(this);
    }
}

