/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import java.util.Set;
import java.util.UUID;
import mage.ApprovingObject;
import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.ReturnFromExileForSourceEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.game.ExileZone;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.util.CardUtil;
import org.apache.log4j.Logger;

class SpellQuellerLeavesEffect
extends OneShotEffect {
    SpellQuellerLeavesEffect() {
        super(Outcome.Benefit);
        this.staticText = "the exiled card's owner may cast that card without paying its mana cost";
    }

    private SpellQuellerLeavesEffect(SpellQuellerLeavesEffect effect) {
        super((OneShotEffect)effect);
    }

    public SpellQuellerLeavesEffect copy() {
        return new SpellQuellerLeavesEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        MageObject sourceObject = source.getSourceObject(game);
        if (controller != null && sourceObject != null) {
            Permanent permanentLeftBattlefield = (Permanent)this.getValue("permanentLeftBattlefield");
            if (permanentLeftBattlefield == null) {
                Logger.getLogger(ReturnFromExileForSourceEffect.class).error((Object)("Permanent not found: " + sourceObject.getName()));
                return false;
            }
            ExileZone exile = game.getExile().getExileZone(CardUtil.getExileZoneId((Game)game, (UUID)source.getSourceId(), (int)permanentLeftBattlefield.getZoneChangeCounter(game)));
            if (exile != null) {
                Player cardOwner;
                Card card = null;
                Set exiledCards = exile.getCards(game);
                if (exiledCards != null && !exiledCards.isEmpty() && (card = (Card)exiledCards.iterator().next()) != null && (cardOwner = game.getPlayer(card.getOwnerId())) != null && cardOwner.chooseUse(Outcome.PlayForFree, "Cast " + card.getLogName() + " without paying cost?", source, game)) {
                    game.getState().setValue("PlayFromNotOwnHandZone" + card.getId(), (Object)Boolean.TRUE);
                    cardOwner.cast(cardOwner.chooseAbilityForCast(card, game, true), game, true, new ApprovingObject(source, game));
                    game.getState().setValue("PlayFromNotOwnHandZone" + card.getId(), null);
                }
            }
            return true;
        }
        return false;
    }
}

