/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.cards.s.SpellbinderCopyEffect;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.DamagedPlayerEvent;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;

class SpellbinderTriggeredAbility
extends TriggeredAbilityImpl {
    SpellbinderTriggeredAbility() {
        super(Zone.BATTLEFIELD, (Effect)new SpellbinderCopyEffect(), true);
    }

    private SpellbinderTriggeredAbility(SpellbinderTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public SpellbinderTriggeredAbility copy() {
        return new SpellbinderTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.DAMAGED_PLAYER;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        DamagedPlayerEvent damageEvent = (DamagedPlayerEvent)event;
        Permanent p = game.getPermanent(event.getSourceId());
        return damageEvent.isCombatDamage() && p != null && p.getAttachments().contains(this.getSourceId());
    }

    public String getRule() {
        return "Whenever equipped creature deals combat damage to a player, you may copy the exiled card. If you do, you may cast the copy without paying its mana cost.";
    }
}

