/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import java.util.Collection;
import java.util.UUID;
import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.Mode;
import mage.abilities.SpellAbility;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.stack.Spell;
import mage.game.stack.StackAbility;
import mage.game.stack.StackObject;
import mage.players.Player;
import mage.target.Target;
import mage.target.Targets;

class SpellskiteEffect
extends OneShotEffect {
    SpellskiteEffect() {
        super(Outcome.Neutral);
        this.staticText = "Change a target of target spell or ability to {this}";
    }

    private SpellskiteEffect(SpellskiteEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        StackObject stackObject = game.getStack().getStackObject(source.getFirstTarget());
        MageObject sourceObject = game.getObject(source);
        if (stackObject != null && sourceObject != null) {
            SpellAbility sourceAbility;
            Targets targets = new Targets();
            String oldTargetName = null;
            if (stackObject instanceof Spell) {
                Spell spell = (Spell)stackObject;
                sourceAbility = spell.getSpellAbility();
            } else if (stackObject instanceof StackAbility) {
                sourceAbility = (StackAbility)stackObject;
            } else {
                return false;
            }
            for (UUID modeId : sourceAbility.getModes().getSelectedModes()) {
                Mode mode = sourceAbility.getModes().get((Object)modeId);
                targets.addAll((Collection)mode.getTargets());
            }
            if (targets.size() == 1 && ((Target)targets.get(0)).getTargets().size() == 1) {
                Target target = (Target)targets.get(0);
                if (target.getFirstTarget().equals(source.getSourceId())) {
                    return true;
                }
                if (target.canTarget(stackObject.getControllerId(), source.getSourceId(), (Ability)sourceAbility, game)) {
                    oldTargetName = this.getTargetName(targets.getFirstTarget(), game);
                    target.clearChosen();
                    target.addTarget(source.getSourceId(), stackObject.getStackAbility(), game);
                }
            } else {
                Player controller = game.getPlayer(source.getControllerId());
                boolean validTargets = false;
                do {
                    for (Target target : targets) {
                        if (target.getTargets().contains(source.getSourceId())) continue;
                        for (UUID targetId : target.getTargets()) {
                            String name = this.getTargetName(targetId, game);
                            if (!target.canTarget(stackObject.getControllerId(), source.getSourceId(), (Ability)sourceAbility, game)) continue;
                            validTargets = true;
                            if (name == null || !controller.chooseUse(Outcome.Neutral, "Change target from " + name + " to " + sourceObject.getLogName() + '?', source, game)) continue;
                            oldTargetName = this.getTargetName(targetId, game);
                            int damageAmount = target.getTargetAmount(targetId);
                            target.remove(targetId);
                            target.addTarget(source.getSourceId(), stackObject.getStackAbility(), game);
                            target.setTargetAmount(source.getSourceId(), damageAmount, game);
                            break;
                        }
                        if (oldTargetName == null) continue;
                        break;
                    }
                    if (oldTargetName != null) continue;
                    game.informPlayer(controller, "You have to select at least one target to change to " + sourceObject.getIdName() + '!');
                } while (validTargets && oldTargetName == null);
            }
            if (oldTargetName != null) {
                game.informPlayers(sourceObject.getLogName() + ": Changed target of " + stackObject.getLogName() + " from " + oldTargetName + " to " + sourceObject.getLogName());
            } else {
                game.informPlayers(sourceObject.getLogName() + ": Target not changed to " + sourceObject.getLogName() + " because it's not a valid target for " + stackObject.getLogName());
            }
            return true;
        }
        return false;
    }

    public SpellskiteEffect copy() {
        return new SpellskiteEffect(this);
    }

    private String getTargetName(UUID objectId, Game game) {
        MageObject object = game.getObject(objectId);
        if (object != null) {
            return object.getLogName();
        }
        Player player = game.getPlayer(objectId);
        if (player != null) {
            return player.getLogName();
        }
        return null;
    }
}

