/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.util.CardUtil;

class SpellweaverHelixImprintEffect
extends OneShotEffect {
    SpellweaverHelixImprintEffect() {
        super(Outcome.Exile);
        this.staticText = "you may exile two target sorcery cards from a single graveyard";
    }

    private SpellweaverHelixImprintEffect(SpellweaverHelixImprintEffect effect) {
        super((OneShotEffect)effect);
    }

    public SpellweaverHelixImprintEffect copy() {
        return new SpellweaverHelixImprintEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            Permanent sourcePermanent = game.getPermanent(source.getSourceId());
            for (UUID targetId : this.getTargetPointer().getTargets(game, source)) {
                Card card = game.getCard(targetId);
                if (card == null) continue;
                controller.moveCardsToExile(card, source, game, true, CardUtil.getExileZoneId((Game)game, (UUID)source.getSourceId(), (int)source.getStackMomentSourceZCC()), source.getSourceObject(game).getIdName());
                if (sourcePermanent == null) continue;
                sourcePermanent.imprint(targetId, game);
            }
            return true;
        }
        return false;
    }
}

