/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.ApprovingObject;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.CardType;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.predicate.Predicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetCardInGraveyard;

class SpellweaverVoluteEffect
extends OneShotEffect {
    SpellweaverVoluteEffect() {
        super(Outcome.PlayForFree);
        this.staticText = "copy the enchanted instant card. You may cast the copy without paying its mana cost. If you do, exile the enchanted card and attach {this} to another instant card in a graveyard";
    }

    private SpellweaverVoluteEffect(SpellweaverVoluteEffect effect) {
        super((OneShotEffect)effect);
    }

    public SpellweaverVoluteEffect copy() {
        return new SpellweaverVoluteEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            Card copiedCard;
            Player ownerEnchanted;
            Card enchantedCard;
            Permanent sourcePermanent = game.getPermanent(source.getSourceId());
            if (sourcePermanent != null && sourcePermanent.getAttachedTo() != null && (enchantedCard = game.getCard(sourcePermanent.getAttachedTo())) != null && game.getState().getZone(enchantedCard.getId()) == Zone.GRAVEYARD && (ownerEnchanted = game.getPlayer(enchantedCard.getOwnerId())) != null && controller.chooseUse(Outcome.Copy, "Create a copy of " + enchantedCard.getName() + '?', source, game) && (copiedCard = game.copyCard(enchantedCard, source, source.getControllerId())) != null && controller.chooseUse(Outcome.PlayForFree, "Cast the copied card without paying mana cost?", source, game)) {
                if (copiedCard.getSpellAbility() != null) {
                    game.getState().setValue("PlayFromNotOwnHandZone" + copiedCard.getId(), (Object)Boolean.TRUE);
                    controller.cast(controller.chooseAbilityForCast(copiedCard, game, true), game, true, new ApprovingObject(source, game));
                    game.getState().setValue("PlayFromNotOwnHandZone" + copiedCard.getId(), null);
                }
                if (controller.moveCards(enchantedCard, Zone.EXILED, source, game)) {
                    FilterCard filter = new FilterCard("instant card in a graveyard");
                    filter.add((Predicate)CardType.INSTANT.getPredicate());
                    TargetCardInGraveyard auraTarget = new TargetCardInGraveyard(filter);
                    if (auraTarget.canChoose(controller.getId(), source, game)) {
                        controller.choose(Outcome.Benefit, (Target)auraTarget, source, game);
                        Card newAuraTarget = game.getCard(auraTarget.getFirstTarget());
                        if (newAuraTarget != null && !enchantedCard.getId().equals(newAuraTarget.getId()) && newAuraTarget.addAttachment(sourcePermanent.getId(), source, game)) {
                            game.informPlayers(sourcePermanent.getLogName() + " was attached to " + newAuraTarget.getLogName());
                        }
                    }
                }
            }
            return true;
        }
        return false;
    }
}

