/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import java.util.Collection;
import java.util.Objects;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.ComparisonType;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.counters.CounterType;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.mageobject.ManaValuePredicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class SphereOfAnnihilationEffect
extends OneShotEffect {
    SphereOfAnnihilationEffect() {
        super(Outcome.Benefit);
        this.staticText = "exile {this}, all creatures and planeswalkers with mana value less than or equal to the number of void counters on it, and all creature and planeswalker cards in graveyards with mana value less than or equal to the number of void counters on it";
    }

    private SphereOfAnnihilationEffect(SphereOfAnnihilationEffect effect) {
        super((OneShotEffect)effect);
    }

    public SphereOfAnnihilationEffect copy() {
        return new SphereOfAnnihilationEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        Permanent permanent = source.getSourcePermanentOrLKI(game);
        if (player == null || permanent == null) {
            return false;
        }
        CardsImpl cards = new CardsImpl((Card)permanent);
        int counters = permanent.getCounters(game).getCount(CounterType.VOID);
        FilterPermanent filter = StaticFilters.FILTER_PERMANENT_CREATURE_OR_PLANESWALKER.copy();
        filter.add((Predicate)new ManaValuePredicate(ComparisonType.FEWER_THAN, counters + 1));
        cards.addAllCards((Collection)game.getBattlefield().getActivePermanents(filter, source.getControllerId(), game));
        game.getState().getPlayersInRange(source.getControllerId(), game).stream().map(arg_0 -> ((Game)game).getPlayer(arg_0)).filter(Objects::nonNull).map(Player::getGraveyard).map(g -> g.getCards(game)).flatMap(Collection::stream).filter(card -> card.isCreature(game) || card.isPlaneswalker(game)).filter(card -> card.getManaValue() <= counters).forEach(arg_0 -> ((Cards)cards).add(arg_0));
        return player.moveCards((Cards)cards, Zone.EXILED, source, game);
    }
}

